import java.io.*;

public class Main {
  public static void main (String args[]) {
    double parametrA = 0, parametrB = 0, parametrC = 0;
    
    Reader r = new BufferedReader(new InputStreamReader(System.in));
    StreamTokenizer inp = new StreamTokenizer(r);
    
    try{
      System.out.print("Podaj parametr A: ");
      while(inp.nextToken() != StreamTokenizer.TT_NUMBER){
        System.out.print("Podaj poprawny parametr A: ");
      }
      parametrA = inp.nval;
    
      System.out.print("Podaj parametr B: ");
      while(inp.nextToken() != StreamTokenizer.TT_NUMBER){
        System.out.print("Podaj poprawny parametr B: ");
      }
      parametrB = inp.nval;
    
      System.out.print("Podaj parametr C: ");
      while(inp.nextToken() != StreamTokenizer.TT_NUMBER){
        System.out.print("Podaj poprawny parametr C: ");
      }
      parametrC = inp.nval;
    }
    catch (IOException e){
      System.out.println("Błąd odczytu!");
      System.exit(-1);
    }

    System.out.println("Parametry równania:");
    System.out.print("A: " + parametrA + ", B: " + parametrB +
                        ", C: " + parametrC + "\n");

    if (parametrA == 0){
      System.out.println ("To nie jest równanie kwadratowe: A = 0!");
    }
    else{
      double delta = parametrB * parametrB - 4 * parametrA * parametrC;
      double wynik;

      if (delta < 0){
        System.out.println ("Delta < 0.");
        System.out.println ("To równanie nie ma rozwiązania "+
                            "w zbiorze liczb rzeczywistych.");
      }
      else if (delta == 0){
        wynik = -parametrB / (2 * parametrA);
        System.out.println ("Rozwiązanie: x = " + wynik);
      }
      else{
        wynik = (-parametrB + Math.sqrt(delta)) / (2 * parametrA);
        System.out.print ("Rozwiązanie: x1 = " + wynik);
        wynik = (-parametrB - Math.sqrt(delta)) / (2 * parametrA);
        System.out.println (", x2 = " + wynik);
      }
    }
  }
}
